<!-- Parent: Arenduse juhendid ja nõuded -->
<!-- Label: api -->
<!-- Label: documentation -->
<!-- Label: standards -->

# API standardid

!!! info
    REST API dokumentatsiooni, versioneerimise ja kvaliteedi standardid SMIT projektidele. Sisaldab praktilisi juhendeid API arendamiseks, dokumenteerimiseks ja versioneerimiseks. Suunatud arendajatele, arhitektidele ja devops inseneridele.

## API dokumentatsiooni põhimõtted

### 1. Dokumentatsiooni kvaliteedi kriteeriumid

- **Täielikkus** - kõik endpoint'id, parameetrid ja vastused dokumenteeritud
- **Selgus** - arusaadav kirjeldus kasutamise konteksti kohta
- **Ajakohasus** - dokumentatsioon vastab tegelikule API-le
- **Praktilisus** - sisaldab töötavaid näiteid ja koodi fragmente
- **Järjepidevus** - ühtne stiil ja struktuur kogu dokumentatsioonis

### 2. Dokumentatsiooni struktuuri standardid

**Põhiline struktuur:**

```text
1. API ülevaade ja eesmärk
2. Autentimise meetodid
3. Endpoint'ide kataloog
4. Andmemudelite kirjeldused
5. Veakoodid ja veakäsitlus
6. Näidised ja kasutusjuhud
7. SDK-d ja integratsioonijuhendid
```

### 3. Keele ja stiili juhendid

- **Eesti ja inglise keel** - API dokumentatsioon inglise keeles, ärimuutujad eesti keeles juhul kui neile arusaadavat inglise keelset vastet pole
- **Selge ja lühike** - väldi keerulisi lausestruktuure
- **Konsistentne terminoloogia** - kasuta samme termineid kogu dokumentatsioonis
- **Aktiivsed laused** - "API tagastab" mitte "andmed tagastatakse"

## OpenAPI/Swagger standardid

### 1. OpenAPI spetsifikatsiooni nõuded

**Kohustuslikud väljad:**

```yaml
openapi: "3.0.3"
info:
  title: "SMIT teenuse API"
  version: "1.0.0"
  description: "Teenuse kirjeldus ja eesmärk"
  contact:
    name: "Meeskond"
    email: "meeskond@smit.sise"
```

### 2. OpenAPI faili nõuded

**Koodibaasis peab olema:**

- **openapi.yml** või **openapi.yaml** fail projekti juurkataloogis
- Fail peab olema ajakohane ja vastama tegelikule API-le
- Fail peab sisaldama kõiki endpoint'e, parameetreid ja skeeme

**README.md peab sisaldama:**

- Link OpenAPI failile: `[API Documentation](./openapi.yml)`
- API ülevaade ja põhifunktsioonid
- Autentimise meetodid ja näited
- Kiire algusjuhend API kasutamiseks

**Näide README.md sektsioonist:**

```markdown
## API Dokumentatsioon

- **[OpenAPI Spetsifikatsioon](./openapi.yml)** - Täielik API dokumentatsioon
- **Swagger UI**: [https://api.smit.sise/docs](https://api.smit.sise/docs)
- **Postman Collection**: [API.postman_collection.json](./API.postman_collection.json)

### Kiire algus

```bash
# Autentimine
curl -H "Authorization: Bearer YOUR_TOKEN" \
     https://api.smit.sise/v1/users

# Kasutaja päring
curl https://api.smit.sise/v1/users/123
```yaml
# Näide tuleb lisada
```

### 3. Endpoint dokumentatsioon

**Iga endpoint peab sisaldama:**

- Selge operatsiooni kirjeldus
- Kõik parameetrid (path, query, header, body)
- Kõik võimalikud vastuse koodid (200, 400, 401, 500 jne)
- Näidised taotluste ja vastuste jaoks
- Autoriseerimisnõuded

**Näide:**

```yaml
/users/{id}:
  get:
    summary: "Kasutaja andmete päring"
    description: "Tagastab kasutaja andmed ID järgi"
    parameters:
      - name: id
        in: path
        required: true
        schema:
          type: integer
        description: "Kasutaja unikaalne identifikaator"
    responses:
      200:
        description: "Kasutaja andmed edukalt tagastatud"
      404:
        description: "Kasutajat ei leitud"
```

### 3. Andmemudelite dokumentatsioon

- **Skeemi definitsioonid** - kasuta komponentide sektsioonid
- **Välja kirjeldused** - selgita iga välja eesmärki
- **Andmetüübid** - määra täpsed andmetüübid ja formaadid
- **Valideerimisreeglid** - kirjenda kohustuslikud väljad ja piirangud

## API versioneerimise strateegia

### 1. URL-põhine versioneerimine (soovituslik)

**Standardne lähenemine SMIT projektides:**

```yaml
# URL struktuur
https://api.smit.sise/v1/users
https://api.smit.sise/v2/users

# OpenAPI spetsifikatsioonis
servers:
  - url: https://api.smit.sise/v1
    description: "API versioon 1"
  - url: https://api.smit.sise/v2
    description: "API versioon 2"
```

**Versioneerimise reeglid:**

- Kasuta suuri versiooni numbreid (v1, v2, v3)
- Versiooninumber URL-is kõige vasakul pool
- Tagasiühilduvus kohustuslik
- Vanade versioonide tugi minimaalselt 6 kuud

### 2. Header-põhine versioneerimine (alternatiiv)

**Accept header kasutamine:**

```http
GET /users HTTP/1.1
Accept: application/vnd.smit.api+json;version=1
```

**Custom header kasutamine:**

```http
GET /users HTTP/1.1
X-API-Version: 1
```

### 3. Versioneerimise kriteeriumid

**Uus versioon vajalik kui:**

- Muudetakse API sisendi/väljundi struktuuri
- Eemaldatakse väli või endpoint
- Muudetakse autentimise meetodit
- Lisatakse breaking changes

**Ei vaja uut versiooni kui:**

- Lisatakse uus väli (optional)
- Lisatakse uus endpoint
- Parandatakse veakoode
- Optimeeritakse jõudlust

## REST API nõuded

### 1. Ressurside URL-i kujud

| URL muster | Kirjeldus | Näide |
|------------|-----------|-------|
| `/X` | Tagastab ressursi X massiivi | `/persons` |
| `/X/{id}` | Tagastab konkreetse X ressursi id järgi | `/persons/1` |
| `/X/Y` | Tagastab X listi, mida on filtreeritud Y järgi | `/persons/applications` |
| `/X/{id}/Y` | Tagastab ressursi Y listi, mis on X id-ga seotud | `/persons/1/applications` |

### 2. HTTP meetodite kasutamine

| HTTP meetod | Toiming | Kirjeldus |
|-------------|---------|-----------|
| `GET` | Lugemine | Tagastab andmeid |
| `POST` | Loomine | Loob uue ressursi |
| `PUT` | Täielik uuendamine | Asendab kogu ressursi |
| `PATCH` | Osaline uuendamine | Uuendab ainult määratud välju |
| `DELETE` | Kustutamine | Eemaldab ressursi |

### 3. Veakäsitlus

**Standardne veavastuse formaat:**

```json
{
  "status": "400",
  "message": "Vale taotlus",
  "code": "VALIDATION_ERROR",
  "details": {
    "field": "email",
    "reason": "Vale email formaat"
  }
}
```

**HTTP veakoodid:**

| Kood | Kirjeldus | Kasutus |
|------|-----------|---------|
| 200 | OK | Edukas päring |
| 201 | Created | Ressursi loomine |
| 400 | Bad Request | Vale taotlus |
| 401 | Unauthorized | Autentimise viga |
| 403 | Forbidden | Autoriseerimise viga |
| 404 | Not Found | Ressurss ei leitud |
| 500 | Internal Server Error | Serveri viga |

## Dokumentatsiooni tööriistad

### 1. Soovitatud tööriistad

| Tööriist | Kasutus | Staatus |
|:---------|:--------|:--------|
| **Swagger UI** | OpenAPI visualiseerimine | Eelistatud |
| **Redoc** | Alternatiiv Swagger UI-le | Toetatud |
| **Postman** | API testimine ja dokumentatsioon | Toetatud |

### 2. CI/CD integratsioon

**Automaatne dokumentatsiooni genereerimine:**

```yaml
# GitHub Actions näide
- name: Generate API Documentation
  run: |
    swagger-codegen generate -i api-spec.yaml -l html2 -o docs/
```

## Näidised ja mallid

### 1. API kirjelduse mall

```yaml
openapi: "3.0.3"
info:
  title: "[Teenuse nimi] API"
  version: "1.0.0"
  description: |
    [Teenuse eesmärk ja funktsioonid]
    
    **Põhifunktsioonid:**
    - Funktsioon 1
    - Funktsioon 2
    
    **SLA:** 99.9% uptime, <200ms response time
  contact:
    name: "[Meeskonna nimi]"
    email: "[meeskond@smit.sise]"
servers:
  - url: https://api.smit.sise/v1
    description: "API versioon 1"
```

### 2. Endpoint näide

```yaml
/users:
  get:
    summary: "Kasutajate nimekiri"
    description: "Tagastab kõik kasutajad koos filtreerimise võimalusega"
    parameters:
      - name: page
        in: query
        schema:
          type: integer
          default: 1
        description: "Lehe number"
      - name: size
        in: query
        schema:
          type: integer
          default: 20
        description: "Kirjete arv lehel"
    responses:
      200:
        description: "Kasutajate nimekiri"
        content:
          application/json:
            schema:
              $ref: '#/components/schemas/UserList'
```

## Seotud dokumendid

- **[Integratsiooni nõuded](integration-requirements.md)** - Sünkroonne/asünkroonne suhtlus, X-TEE integratsioon

- **[API Directory](../08-external-integration/api-directory.md)** - API-de registreerimine ja avastamine

## Märkused

- **API dokumentatsioon** peab olema ajakohane ja täielik
- **Versioneerimine** järgib URL-põhist lähenemist
- **Tagasiühilduvus** on kohustuslik kõigile API-dele
- **Dokumentatsioon** genereeritakse automaatselt CI/CD kaudu

---

> **📝 Git-managed page:** This content is automatically synced from [IDP Documentation Repository](https://source.smit.sise/projects/IDP/repos/idp-docs/browse/02-development-guidelines/api-documentation-standards.md). **Do not edit manually in Confluence** - all changes should be made in Git and will be automatically deployed.
